import re
from libprs500.ebooks.lrf.web.profiles import DefaultProfile

class MorningNews(DefaultProfile):

    title = 'Morning News'
    max_recursions = 2
    max_articles_per_feed = 2
    
    preprocess_regexps = [ (re.compile(i[0], re.IGNORECASE | re.DOTALL), i[1]) for i in 
[
    	(r'<HEAD>.*?</HEAD>' , lambda match : '<HEAD></HEAD>'),
    	(r'<BODY.*?>.*?<!-- start Entries -->', lambda match : '<BODY><!-- start Entries -->'),
	    (r'<!-- end Entries -->.*?</BODY>', lambda match : '</BODY>'),
	    (r'<script>.*?</script>', lambda match : ''),
	    (r'<div class="apple-rss-unread-dot">.*?</div>', lambda match : ''),
	    (r'<IMG border="0" src="http://images.*?>.*?</td>', lambda match : ''),

    ]
    ]   
     

  
    def get_feeds(self):
     	return [ ('News', 'http://www.nwaonline.net/?rss=news'),
     	         ('Our Town', 'http://www.nwaonline.net/?rss=our_town'),
     	         ('Religion', 'http://www.nwaonline.net/?rss=religion'),
     	] 

    def print_version(self, url):
		return (url.rpartition('.')[0] + '.prt')
		
		